<?php
/**
 * @author  RadiusTheme
 * @since   1.2
 * @version 1.2
 */

namespace radiustheme\Classima_Core;

use Elementor\Plugin;
use \WPCF7_ContactFormTemplate;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Demo_Importer_OCDI {

	public function __construct() {
		add_filter( 'ocdi/import_files', array( $this, 'demo_config' ) );
		add_filter( 'ocdi/before_content_import', array( $this, 'before_import' ) );
		add_filter( 'ocdi/after_import', array( $this, 'after_import' ) );
		add_action( 'ocdi/before_widgets_import', array( $this, 'remove_default_widgets' ) );
		add_filter( 'ocdi/disable_pt_branding', '__return_true' );
		add_action( 'init', array( $this, 'rewrite_flush_check' ) );
	}

	public function demo_config() {

		$demos_array = array(
			'demo1'  => array(
				'title'        => __( 'Home 1', 'classima-core' ),
				'page'         => __( 'Home 1', 'classima-core' ),
				'screenshot'   => plugins_url( 'screenshots/screenshot1.png', dirname( __FILE__ ) ),
				'preview_link' => 'https://radiustheme.com/demo/wordpress/themes/classima/',
			),
			'demo2'  => array(
				'title'        => __( 'Home 2', 'classima-core' ),
				'page'         => __( 'Home 2', 'classima-core' ),
				'screenshot'   => plugins_url( 'screenshots/screenshot2.png', dirname( __FILE__ ) ),
				'preview_link' => 'https://radiustheme.com/demo/wordpress/themes/classima/home-2/',
			),
			'demo3'  => array(
				'title'        => __( 'Home 3', 'classima-core' ),
				'page'         => __( 'Home 3', 'classima-core' ),
				'screenshot'   => plugins_url( 'screenshots/screenshot3.png', dirname( __FILE__ ) ),
				'preview_link' => 'https://radiustheme.com/demo/wordpress/themes/classima/home-3/',
			),
			'demo4'  => array(
				'title'        => __( 'Home 4', 'classima-core' ),
				'page'         => __( 'Home 4', 'classima-core' ),
				'screenshot'   => plugins_url( 'screenshots/screenshot4.png', dirname( __FILE__ ) ),
				'preview_link' => 'https://radiustheme.com/demo/wordpress/themes/classima/home-4/',
			),
			'demo5'  => array(
				'title'        => __( 'Home 5', 'classima-core' ),
				'page'         => __( 'Home 5', 'classima-core' ),
				'screenshot'   => plugins_url( 'screenshots/screenshot5.png', dirname( __FILE__ ) ),
				'preview_link' => 'https://radiustheme.com/demo/wordpress/themes/classima/home-5/',
			),
			'demo6'  => array(
				'title'        => __( 'Home 6', 'classima-core' ),
				'page'         => __( 'Home 6', 'classima-core' ),
				'screenshot'   => plugins_url( 'screenshots/screenshot6.png', dirname( __FILE__ ) ),
				'preview_link' => 'https://radiustheme.com/demo/wordpress/themes/classima/home-6/',
			),
			'demo7'  => array(
				'title'        => __( 'Home 7', 'classima-core' ),
				'page'         => __( 'Home 7', 'classima-core' ),
				'screenshot'   => plugins_url( 'screenshots/screenshot7.png', dirname( __FILE__ ) ),
				'preview_link' => 'https://radiustheme.com/demo/wordpress/themes/classima/home-7/',
			),
			'demo8'  => array(
				'title'        => __( 'Home 8', 'classima-core' ),
				'page'         => __( 'Home 8', 'classima-core' ),
				'screenshot'   => plugins_url( 'screenshots/screenshot8.png', dirname( __FILE__ ) ),
				'preview_link' => 'https://radiustheme.com/demo/wordpress/themes/classima/home-8/',
			),
			'demo9'  => array(
				'title'        => __( 'Home 9', 'classima-core' ),
				'page'         => __( 'Home 9', 'classima-core' ),
				'screenshot'   => plugins_url( 'screenshots/screenshot9.png', dirname( __FILE__ ) ),
				'preview_link' => 'https://radiustheme.com/demo/wordpress/themes/classima/home-9/',
			),
			'demo10' => array(
				'title'        => __( 'Home 10', 'classima-core' ),
				'page'         => __( 'Home 10', 'classima-core' ),
				'screenshot'   => plugins_url( 'screenshots/screenshot10.png', dirname( __FILE__ ) ),
				'preview_link' => 'https://radiustheme.com/demo/wordpress/themes/classima/home-10/',
			),
			'demo11' => array(
				'title'        => __( 'Home 11', 'classima-core' ),
				'page'         => __( 'Home 11', 'classima-core' ),
				'screenshot'   => plugins_url( 'screenshots/screenshot11.png', dirname( __FILE__ ) ),
				'preview_link' => 'https://radiustheme.com/demo/wordpress/themes/classima/home-11/',
			),
			'demo12' => array(
				'title'        => __( 'Home 12', 'classima-core' ),
				'page'         => __( 'Home 12', 'classima-core' ),
				'screenshot'   => plugins_url( 'screenshots/screenshot12.png', dirname( __FILE__ ) ),
				'preview_link' => 'https://radiustheme.com/demo/wordpress/themes/classima/home-12/',
			),
		);

		$config       = array();
		$import_path  = trailingslashit( CLASSIMA_CORE_BASE_DIR ) . 'sample-data/';
		$redux_option = 'classima';

		foreach ( $demos_array as $key => $demo ) {
			$config[] = array(
				'import_file_id'               => $key,
				'import_page_name'             => $demo['page'],
				'import_file_name'             => $demo['title'],
				'local_import_file'            => $import_path . 'contents.xml',
				'local_import_widget_file'     => $import_path . 'widgets.wie',
				'local_import_customizer_file' => $import_path . 'customizer.dat',
				'local_import_redux'           => array(
					array(
						'file_path'   => $import_path . 'options.json',
						'option_name' => $redux_option,
					),
				),
				'import_preview_image_url'     => $demo['screenshot'],
				'preview_url'                  => $demo['preview_link'],
			);
		}

		return $config;
	}

	public function before_import( $selected_import ) {
		$this->remove_default_rtcl_pages();
		$this->remove_rtcl_builder_default_form();
		$this->import_rtcl_builder_forms();
	}

	public function after_import( $selected_import ) {
		$this->assign_menu( $selected_import['import_file_id'] );
		$this->assign_frontpage( $selected_import );
		$this->update_contact_form_sender_email();
		$this->update_permalinks();
		$this->site_widde_modify();
		$this->rtcl_taxonomy_migration();
		$this->setFormBuilderCondition();
		$this->rtcl_options_migration();
		$this->update_rtcl_options();
		$this->set_elementor_active_kit();
		$this->set_elementor_settings();

		flush_rewrite_rules();
		update_option( 'classima_ocdi_importer_rewrite_flash', true );
	}

	public function site_widde_modify() {
		// Get the "Hello World!" post by title.
		$post_id = $this->get_page_by_title( 'Hello World!', 'post' );

		if ( $post_id ) {
			wp_trash_post( $post_id );
		}
	}

	/**
	 * Sets the active Elementor kit.
	 *
	 * @return $this
	 */
	private function set_elementor_active_kit() {
		global $wpdb;

		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
		$pageIds = $wpdb->get_results(
			$wpdb->prepare(
				"SELECT ID FROM $wpdb->posts WHERE (post_name = %s OR post_title = %s) AND post_type = 'elementor_library' AND post_status = 'publish'",
				'default-kit',
				'Default Kit'
			)
		);

		if ( ! is_null( $pageIds ) ) {
			$pageId    = 0;
			$deleteIds = [];

			// Retrieve page with greater id and delete others.
			if ( count( $pageIds ) > 1 ) {
				foreach ( $pageIds as $page ) {
					if ( $page->ID > $pageId ) {
						if ( $pageId ) {
							$deleteIds[] = $pageId;
						}
						$pageId = $page->ID;
					} else {
						$deleteIds[] = $page->ID;
					}
				}
			} else {
				$pageId = $pageIds[0]->ID;
			}

			// Update `elementor_active_kit` page.
			if ( $pageId > 0 ) {
				wp_update_post(
					[
						'ID'        => $pageId,
						'post_name' => sanitize_title( 'Default Kit' ),
					]
				);
				update_option( 'elementor_active_kit', $pageId );
			}
		}

		return $this;
	}


	/**
	 * Sets the Elementor default settings.
	 *
	 * @return $this
	 */
	private function set_elementor_settings() {
		update_option( 'elementor_disable_color_schemes', 'yes' );
		update_option( 'elementor_disable_typography_schemes', 'yes' );
		update_option( 'elementor_unfiltered_files_upload', '1' );
		update_option( 'elementor_experiment-e_font_icon_svg', 'inactive' );

		return $this;
	}

	public function rtcl_taxonomy_migration() {
		$args = [
			'post_type'      => 'page',
			'post_status'    => 'publish',
			'posts_per_page' => - 1,
			'fields'         => 'ids',
			'meta_query'     => [
				[
					'key'     => '_elementor_data',
					'compare' => 'EXISTS',
				],
			],
		];

		$query = get_posts( $args );

		/*$meta_json  = get_post_meta( 802, '_elementor_data', 'true' );
		$meta_json2 = get_post_meta( 767, '_elementor_data', 'true' );

		error_log( print_r( $meta_json, true ) . "\n", 3, __DIR__ . '/log_802.json' );
		error_log( print_r( $meta_json2, true ) . "\n", 3, __DIR__ . '/log_767.json' );*/

		$old_location_id = [
			'rtcl_location' => [
				'new-jersey'   => 31,
				'bloomfield'   => 32,
				'california'   => 33,
				'cape-may'     => 34,
				'kansas'       => 36,
				'bakersfield'  => 37,
				'abilene'      => 38,
				'claremont'    => 41,
				'louisiana'    => 43,
				'hutchinson'   => 45,
				'downey'       => 46,
				'bogalusa'     => 48,
				'port-chester' => 50,
				'monroe'       => 52,
				'new-orleans'  => 54,
				'brooklyn'     => 57,
			],
			'rtcl_category' => [
				'business-industry' => 61,
				'cars-vehicles'     => 62,
				'education'         => 64,
				'electronics'       => 65,
				'health-beauty'     => 68,
				'hobby-sport-kids'  => 70,
				'home-appliances'   => 71,
				'jobs'              => 76,
				'others'            => 98,
				'pets-animals'      => 100,
				'property'          => 102,
				'services'          => 107,
				'dogs'              => 179,
				'cats'              => 180,
				'rabbit'            => 181,
				'birds'             => 182,
				'fish'              => 183,
				'hen'               => 184,
			]
		];

		foreach ( $query as $page_id ) {
			$meta_json = get_post_meta( $page_id, '_elementor_data', true );
			$meta_data = json_decode( $meta_json, true );

			$new_location_ids = [];
			foreach ( $old_location_id as $tax => $taxonomies ) {
				foreach ( $taxonomies as $slug => $id ) {
					$term = get_term_by( 'slug', $slug, $tax );
					if ( $term && isset( $term->term_id ) ) {
						$new_location_ids[ $id ] = $term->term_id;
					}
				}
			}

			if ( ! empty( $new_location_ids ) ) {
				$this->replaceLocation( $meta_data, $new_location_ids );
				$updatedJson = wp_slash( wp_json_encode( $meta_data ) );
				update_post_meta( $page_id, '_elementor_data', $updatedJson );

				Plugin::instance()->files_manager->clear_cache();
			}
		}
	}

	public function replaceLocation( &$array, $tax_ids ) {
		if ( ! empty( $array ) ) {
			foreach ( $array as $key => &$value ) {
				if ( ! in_array( $key, [ "location", "cats" ] ) ) {
					if ( is_array( $value ) ) {
						$this->replaceLocation( $value, $tax_ids );
					}
				} else {
					if ( is_array( $value ) ) {
						$new_value = [];
						foreach ( $value as $id ) {
							if ( isset( $tax_ids[ $id ] ) ) {
								$new_value[] = $tax_ids[ $id ];
							}
						}
						$value = $new_value;
					} else {
						$value = $tax_ids[ $value ] ?? '';
					}
				}
			}
		}
	}

	private function assign_menu( $demo ) {
		$primary = get_term_by( 'name', 'Main Menu', 'nav_menu' );

		set_theme_mod( 'nav_menu_locations', array(
			'primary' => $primary->term_id,
		) );
	}

	private function assign_frontpage( $selected_import ) {
		$blog_page  = $this->get_page_by_title( 'Blog' );
		$front_page = $this->get_page_by_title( $selected_import['import_page_name'] );

		update_option( 'show_on_front', 'page' );
		update_option( 'page_on_front', $front_page );
		update_option( 'page_for_posts', $blog_page );
	}

	private function update_contact_form_sender_email() {
		$form1 = get_page_by_title( 'Contact', OBJECT, 'wpcf7_contact_form' );

		$forms = array( $form1 );
		foreach ( $forms as $form ) {
			if ( ! $form ) {
				continue;
			}
			$cf7id = $form->ID;
			$mail  = get_post_meta( $cf7id, '_mail', true );
			if ( class_exists( 'WPCF7_ContactFormTemplate' ) ) {
				$pattern        = "/<[^@\s]*@[^@\s]*\.[^@\s]*>/"; // <email@email.com>
				$replacement    = '<' . WPCF7_ContactFormTemplate::from_email() . '>';
				$mail['sender'] = preg_replace( $pattern, $replacement, $mail['sender'] );
			}
			update_post_meta( $cf7id, '_mail', $mail );
		}
	}

	private function update_permalinks() {
		update_option( 'permalink_structure', '/%postname%/' );
	}

	public function rtcl_options_migration() {
		$formFile = trailingslashit( CLASSIMA_CORE_BASE_DIR ) . 'sample-data/rtcl-settings.json';
		if ( file_exists( $formFile ) ) {
			// phpcs:ignore WordPress.WP.AlternativeFunctions.file_get_contents_file_get_contents
			$data = json_decode( file_get_contents( $formFile ), true );

			if ( $data && is_array( $data ) ) {
				foreach ( $data as $value ) {
					$key   = $value['key'] ?? null;
					$value = $value['value'] ?? null;
					if ( $key && $value ) {
						update_option( $key, $value );
					}
				}
			}
		}

	}

	private function update_rtcl_options() {
		$listings     = $this->get_page_by_title( 'All Ads' );
		$listing_form = $this->get_page_by_title( 'Post an Ad' );
		$myaccount    = $this->get_page_by_title( 'My Account' );
		$checkout     = $this->get_page_by_title( 'Checkout' );
		$store        = $this->get_page_by_title( 'Stores' );

		$data = array(
			'rtcl_general_settings'    => array(
				'listings_per_page' => 9,
				'default_view'      => 'grid',
				'currency_position' => 'left',
			),
			'rtcl_moderation_settings' => array(
				'listing_duration'       => 0,
				'new_listing_threshold'  => 155,
				'listing_bump_up_label'  => '',
				'display_options'        => array(
					'category',
					'location',
					'date',
					'price',
					'views',
					'excerpt',
					'new',
					'popular'
				),
				'display_options_detail' => array(
					'location',
					'date',
					'user',
					'price',
					'views',
					'top',
					'featured',
					'new',
					'popular'
				),
				'has_comment_form'       => 'yes',
				'enable_review_rating'   => 'yes',
				'enable_update_rating'   => 'yes',
			),
			'rtcl_advanced_settings'   => array(
				'permalink'    => 'listing',
				'listings'     => $listings,
				'listing_form' => $listing_form,
				'myaccount'    => $myaccount,
				'checkout'     => $checkout,
				'store'        => $store,
			),
			'rtcl_style_settings'      => array(
				'new' => '#e7291e',
			)
		);

		foreach ( $data as $key => $value ) {
			$defaults = get_option( $key, array() );
			$args     = wp_parse_args( $value, $defaults );
			update_option( $key, $args );
		}
	}

	private function remove_default_rtcl_pages() {
		$listings     = $this->get_page_by_title( 'Listings', 'page' );
		$listing_form = $this->get_page_by_title( 'Listing Form', 'page' );
		$myaccount    = $this->get_page_by_title( 'My Account' );
		$checkout     = $this->get_page_by_title( 'Checkout' );

		if ( $listings ) {
			wp_delete_post( $listings, true );
		}
		if ( $listing_form ) {
			wp_delete_post( $listing_form, true );
		}
		if ( $myaccount ) {
			wp_delete_post( $myaccount, true );
		}
		if ( $checkout ) {
			wp_delete_post( $checkout, true );
		}
	}

	private function import_rtcl_builder_forms() {

		$formFile = trailingslashit( CLASSIMA_CORE_BASE_DIR ) . 'sample-data/rtclform.json';

		$fileExists = file_exists( $formFile );


		if ( $fileExists ) {
			// phpcs:ignore WordPress.WP.AlternativeFunctions.file_get_contents_file_get_contents
			$data  = file_get_contents( $formFile );
			$forms = json_decode( $data, true );

			if ( $forms && is_array( $forms ) ) {
				foreach ( $forms as $formItem ) {
					\Rtcl\Models\Form\Form::query()->insert( $formItem );
				}
			}
		}
	}

	private function remove_rtcl_builder_default_form() {
		global $wpdb;
		$table = $wpdb->prefix . 'rtcl_forms';
		$wpdb->query( "TRUNCATE TABLE $table" );
	}

	public function rewrite_flush_check() {
		if ( get_option( 'classima_ocdi_importer_rewrite_flash' ) == true ) {
			flush_rewrite_rules();
			delete_option( 'classima_ocdi_importer_rewrite_flash' );
		}
	}

	private function get_page_by_title( $title, $post_type = 'page' ) {
		$page = get_posts( array(
			'post_type'   => $post_type,
			'name'        => sanitize_title( $title ),
			'post_status' => 'publish',
			'numberposts' => 1
		) );

		if ( $page ) {
			$page = $page[0];

			return $page->ID;
		} else {
			return null;
		}
	}

	public function remove_default_widgets( $selected_import ) {
		delete_option( 'sidebars_widgets' );
	}

	// Mapping old to new terms
	public function mapping_old_to_new_terms() {
		$old_term_ids = [
			'rtcl_location' => [
				'new-jersey'   => 31,
				'bloomfield'   => 32,
				'california'   => 33,
				'cape-may'     => 34,
				'kansas'       => 36,
				'bakersfield'  => 37,
				'abilene'      => 38,
				'claremont'    => 41,
				'louisiana'    => 43,
				'hutchinson'   => 45,
				'downey'       => 46,
				'bogalusa'     => 48,
				'port-chester' => 50,
				'monroe'       => 52,
				'new-orleans'  => 54,
				'brooklyn'     => 57,
			],
			'rtcl_category' => [
				'business-industry'               => 61,
				'cars-vehicles'                   => 62,
				'industry-machinery-tools'        => 73,
				'education'                       => 64,
				'electronics'                     => 65,
				'cameras-camcorders'              => 188,
				'freeze'                          => 190,
				'air-conditioner-ac'              => 189,
				'other-electronics'               => 94,
				'childrens-items'                 => 147,
				'computers-tablets'               => 150,
				'health-beauty'                   => 68,
				'hobby-sport-kids'                => 70,
				'home-appliances'                 => 71,
				'jobs'                            => 76,
				'others'                          => 98,
				'pets-animals'                    => 100,
				'property'                        => 102,
				'houses'                          => 164,
				'home-appliances-home-appliances' => 72,
				'others-home-items'               => 99,
				'services'                        => 107,
				'dogs'                            => 179,
				'cats'                            => 180,
				'rabbit'                          => 181,
				'birds'                           => 182,
				'fish'                            => 183,
				'hen'                             => 184,
			]
		];

		return $old_term_ids;
	}

	public function build_old_to_new_mapping() {
		$mapping              = [];
		$old_taxonomy_term_id = $this->mapping_old_to_new_terms();

		foreach ( $old_taxonomy_term_id as $taxonomy => $terms ) {
			foreach ( $terms as $slug => $old_id ) {
				$new_term = get_term_by( 'slug', $slug, $taxonomy );
				if ( $new_term && ! is_wp_error( $new_term ) ) {
					$mapping[ $old_id ] = $new_term->term_id;
				}
			}
		}

		return $mapping;
	}

	private function setFormBuilderCondition() {
		global $wpdb;

		$table_name = $wpdb->prefix . 'rtcl_forms';

		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
		if ( $wpdb->get_var( $wpdb->prepare( 'SHOW TABLES LIKE %s', $table_name ) ) !== $table_name ) {
			return;
		}

		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.InterpolatedNotPrepared
		$forms = $wpdb->get_results( "SELECT * FROM {$table_name}", ARRAY_A );

		foreach ( $forms as $form ) {
			$fields_updated   = false;
			$sections_updated = false;

			if ( ! empty( $form['fields'] ) ) {
				$form_data = $this->parseJsonOrSerialized( $form['fields'] );

				if ( is_array( $form_data ) ) {
					$fields_updated = $this->processFieldConditions( $form_data );
				}
			}

			$sections_data = null;
			if ( ! empty( $form['sections'] ) ) {
				$sections_data = $this->parseJsonOrSerialized( $form['sections'] );

				if ( is_array( $sections_data ) && ! empty( $form['fields'] ) ) {
					$fields_for_reference = $this->parseJsonOrSerialized( $form['fields'] );
					if ( is_array( $fields_for_reference ) ) {
						$sections_updated = $this->processSectionConditions( $sections_data, $fields_for_reference );
					}
				}
			}

			$update_data   = [];
			$update_format = [];

			if ( $fields_updated && ! empty( $form['fields'] ) ) {
				$update_data['fields'] = $this->encodeInOriginalFormat( $form_data, $form['fields'] );
				$update_format[]       = '%s';
			}

			if ( $sections_updated && ! empty( $form['sections'] ) ) {
				$update_data['sections'] = $this->encodeInOriginalFormat( $sections_data, $form['sections'] );
				$update_format[]         = '%s';
			}

			if ( ! empty( $update_data ) ) {
				// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
				$wpdb->update(
					$table_name,
					$update_data,
					[ 'id' => $form['id'] ],
					$update_format,
					[ '%d' ]
				);
			}
		}
	}

	private function encodeInOriginalFormat( $data, $original_data ) {
		if ( ! $this->is_serialized_data( $original_data ) ) {
			$test_json = json_decode( $original_data, true );
			if ( json_last_error() === JSON_ERROR_NONE && is_array( $test_json ) ) {
				return wp_json_encode( $data );
			}
		}

		return maybe_serialize( $data );
	}

	private function processSectionConditions( &$sections_data, $fields_data ) {
		$updated = false;

		$term_mapping = $this->build_old_to_new_mapping();

		foreach ( $sections_data as &$section ) {
			if ( ! isset( $section['logics']['conditions'] ) || ! is_array( $section['logics']['conditions'] ) ) {
				continue;
			}

			foreach ( $section['logics']['conditions'] as &$condition ) {
				if ( ! isset( $condition['fieldId'] ) || ! isset( $condition['value'] ) ) {
					continue;
				}

				$field_id = $condition['fieldId'];

				if ( $this->isCategoryField( $fields_data, $field_id ) ) {
					$old_id = $condition['value'];

					if ( ! empty( $term_mapping && is_array( $term_mapping ) ) ) {
						$new_id = $term_mapping[ $old_id ] ?? null;

						if ( $new_id && $new_id !== $old_id ) {
							$condition['value'] = $new_id;
							$updated            = true;
						}
					}
				}
			}
		}

		return $updated;
	}

	/**
	 * Check if a field is a category field
	 *
	 * @param array  $form_data All form field data.
	 * @param string $field_id  The field ID to check.
	 *
	 * @return bool
	 * @since 1.1.6
	 */
	private function isCategoryField( $form_data, $field_id ) {
		if ( ! isset( $form_data[ $field_id ] ) ) {
			return false;
		}

		$field = $form_data[ $field_id ];

		return isset( $field['name'] ) && 'category' === $field['name']
		       && isset( $field['element'] )
		       && 'category' === $field['element'];
	}

	private function processFieldConditions( &$form_data ) {
		$updated = false;

		$term_mapping = $this->build_old_to_new_mapping();

		foreach ( $form_data as &$field_config ) {
			if ( ! isset( $field_config['logics']['conditions'] ) || ! is_array( $field_config['logics']['conditions'] ) ) {
				continue;
			}

			foreach ( $field_config['logics']['conditions'] as &$condition ) {
				if ( ! isset( $condition['fieldId'] ) || ! isset( $condition['value'] ) ) {
					continue;
				}

				$field_id = $condition['fieldId'];

				if ( $this->isCategoryField( $form_data, $field_id ) ) {
					$old_id = $condition['value'];

					if ( ! empty( $term_mapping && is_array( $term_mapping ) ) ) {
						$new_id = $term_mapping[ $old_id ] ?? null;

						if ( $new_id && $new_id !== $old_id ) {
							$condition['value'] = $new_id;
							$updated            = true;
						}
					}
				}
			}
		}

		return $updated;
	}

	private function parseJsonOrSerialized( $data ) {
		if ( empty( $data ) ) {
			return null;
		}

		$parsed = maybe_unserialize( $data );

		if ( ! is_array( $parsed ) ) {
			$parsed = json_decode( $data, true );
		}

		return is_array( $parsed ) ? $parsed : null;
	}

	/**
	 * Check if a string is serialized data
	 *
	 * @param string $data The string to check
	 *
	 * @return bool True if the string is serialized
	 */
	private function is_serialized_data( $data ) {
		if ( ! is_string( $data ) ) {
			return false;
		}

		$data = trim( $data );
		if ( 'N;' === $data ) {
			return true;
		}

		if ( strlen( $data ) < 4 ) {
			return false;
		}

		if ( ':' !== $data[1] ) {
			return false;
		}

		$lastc = substr( $data, - 1 );
		if ( ';' !== $lastc && '}' !== $lastc ) {
			return false;
		}

		$token = $data[0];
		switch ( $token ) {
			case 's':
				if ( '"' !== substr( $data, - 2, 1 ) ) {
					return false;
				}
			// fall through
			case 'a':
			case 'O':
				return (bool) preg_match( "/^{$token}:[0-9]+:/s", $data );
			case 'b':
			case 'i':
			case 'd':
				$end = '';

				return (bool) preg_match( "/^{$token}:[0-9.E+-]+;$/", $data );
		}

		return false;
	}
}

new Demo_Importer_OCDI;