<?php
/**
 *Manage Listing by user
 *
 * @author        RadiusTheme
 * @package       classified-listing/templates
 * @version       1.0.0
 *
 * @var WP_Query $rtcl_query
 */


use Rtcl\Helpers\Functions;
use Rtcl\Helpers\Pagination;

global $post;
?>

<?php if ( $rtcl_query->have_posts() ): ?>
	<div class="rtcl-MyAccount-content-inner">
		<table class="rtcl-my-listing-table">
			<thead>
			<tr>
				<th><?php esc_html_e( 'Thumbnail', 'classified-listing' ); ?></th>
				<th class="title-cell"><?php esc_html_e( 'Title', 'classified-listing' ); ?></th>
				<th class="price-cell list-on-responsive"><?php esc_html_e( 'Price', 'classified-listing' ); ?></th>
				<th class="list-on-responsive"><?php esc_html_e( 'Expires On', 'classified-listing' ); ?></th>
				<th class="list-on-responsive"><?php esc_html_e( 'Status', 'classified-listing' ); ?></th>
				<th class="list-on-responsive"><?php esc_html_e( 'Action', 'classified-listing' ); ?></th>
			</tr>
			</thead>
			<tbody>
			<?php while ( $rtcl_query->have_posts() ) : $rtcl_query->the_post();
				$post_meta  = get_post_meta( $post->ID );
				$listing    = rtcl()->factory->get_listing( $post->ID );
				$is_top     = (bool) get_post_meta( $listing->get_id(), '_top', true );
				$is_bump_up = (bool) get_post_meta( $listing->get_id(), '_bump_up', true );
				?>
				<tr>
					<td>
						<div class="listing-thumb">
							<a href="<?php the_permalink(); ?>"><?php $listing->the_thumbnail(); ?></a>
							<?php do_action( 'rtcl_my_listing_after_listing_thumb', $listing ); ?>
						</div>
					</td>
					<td class="title-cell">
						<div class="rtcl-ad-details">
							<a class="listing-title" href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
							<?php $listing->the_badges(); ?>
							<ul class="rtcl-meta">
								<li>
									<svg width="16" height="16" viewBox="0 0 16 16" fill="none"
										 xmlns="http://www.w3.org/2000/svg">
										<path fill-rule="evenodd" clip-rule="evenodd"
											  d="M7.99941 1.60002C4.46479 1.60002 1.59941 4.4654 1.59941 8.00002C1.59941 11.5346 4.46479 14.4 7.99941 14.4C11.534 14.4 14.3994 11.5346 14.3994 8.00002C14.3994 4.4654 11.534 1.60002 7.99941 1.60002ZM0.399414 8.00002C0.399414 3.80266 3.80205 0.400024 7.99941 0.400024C12.1968 0.400024 15.5994 3.80266 15.5994 8.00002C15.5994 12.1974 12.1968 15.6 7.99941 15.6C3.80205 15.6 0.399414 12.1974 0.399414 8.00002ZM7.99941 3.20002C8.33078 3.20002 8.59941 3.46865 8.59941 3.80002V7.6292L11.0677 8.86337C11.3641 9.01156 11.4843 9.37196 11.3361 9.66835C11.1879 9.96474 10.8275 10.0848 10.5311 9.93668L7.73108 8.53668C7.52781 8.43505 7.39941 8.22729 7.39941 8.00002V3.80002C7.39941 3.46865 7.66804 3.20002 7.99941 3.20002Z"
											  fill="currentColor"/>
									</svg>
									<?php $listing->the_time(); ?>
								</li>
								<?php if ( $listing->has_category() ): ?>
									<li>
										<svg width="16" height="16" viewBox="0 0 16 16" fill="none"
											 xmlns="http://www.w3.org/2000/svg">
											<path fill-rule="evenodd" clip-rule="evenodd"
												  d="M0.399414 1.00002C0.399414 0.668653 0.668044 0.400024 0.999414 0.400024H8.30189C8.46104 0.400024 8.61368 0.46326 8.72621 0.575815L15.0003 6.85154C15.384 7.23769 15.5994 7.76 15.5994 8.30441C15.5994 8.84881 15.384 9.37113 15.0003 9.75727L14.999 9.75853L9.76339 14.9955C9.57204 15.1871 9.34479 15.3392 9.09464 15.4429C8.84448 15.5466 8.57634 15.6 8.30554 15.6C8.03474 15.6 7.76659 15.5466 7.51644 15.4429C7.26649 15.3392 7.03941 15.1874 6.84815 14.996C6.8483 14.9961 6.84799 14.9958 6.84815 14.996L0.575342 8.72886C0.462703 8.61633 0.399414 8.46363 0.399414 8.30441V1.00002ZM1.59941 1.60002V8.05572L7.69631 14.1471C7.77623 14.2271 7.87162 14.2911 7.97607 14.3344C8.08052 14.3777 8.19247 14.4 8.30554 14.4C8.4186 14.4 8.53056 14.3777 8.635 14.3344C8.73945 14.2911 8.83436 14.2276 8.91428 14.1476L14.1491 8.91138C14.1493 8.91119 14.1489 8.91157 14.1491 8.91138C14.309 8.75015 14.3994 8.53162 14.3994 8.30441C14.3994 8.0772 14.3096 7.85924 14.1497 7.69801C14.1499 7.6982 14.1495 7.69782 14.1497 7.69801L8.05331 1.60002H1.59941ZM4.05065 4.65222C4.05065 4.32084 4.31928 4.05222 4.65065 4.05222H4.65795C4.98932 4.05222 5.25795 4.32084 5.25795 4.65222C5.25795 4.98359 4.98932 5.25222 4.65795 5.25222H4.65065C4.31928 5.25222 4.05065 4.98359 4.05065 4.65222Z"
												  fill="currentColor"/>
										</svg>
										<?php $listing->the_categories( true, true ); ?>
									</li>
								<?php endif; ?>
								<?php if ( $listing->has_location() && apply_filters( 'rtcl_my_listing_location_display', false ) ): ?>
									<li>
										<svg width="13" height="16" viewBox="0 0 13 16" fill="none"
											 xmlns="http://www.w3.org/2000/svg">
											<path fill-rule="evenodd" clip-rule="evenodd"
												  d="M6.49941 1.60002C5.20787 1.60002 3.96406 2.13406 3.04309 3.09309C2.12132 4.05295 1.59941 5.3598 1.59941 6.7273C1.59941 8.7224 2.84381 10.6471 4.19323 12.1303C4.85707 12.86 5.52277 13.4571 6.02302 13.8719C6.20793 14.0253 6.3696 14.1532 6.49941 14.2531C6.62922 14.1532 6.7909 14.0253 6.9758 13.8719C7.47605 13.4571 8.14176 12.86 8.8056 12.1303C10.155 10.6471 11.3994 8.7224 11.3994 6.7273C11.3994 5.3598 10.8775 4.05295 9.95571 3.09309C9.03481 2.13406 7.79095 1.60002 6.49941 1.60002ZM6.49941 15C6.15725 15.4929 6.1571 15.4928 6.15692 15.4926L6.15519 15.4914L6.15114 15.4886L6.13717 15.4788C6.12529 15.4704 6.10835 15.4583 6.08667 15.4427C6.04332 15.4114 5.98101 15.3658 5.90245 15.3068C5.74538 15.1886 5.523 15.0162 5.25705 14.7957C4.72605 14.3554 4.01676 13.7195 3.3056 12.9379C1.90502 11.3984 0.399414 9.18674 0.399414 6.7273C0.399414 5.05686 1.03643 3.4502 2.17756 2.26191C3.31949 1.0728 4.87357 0.400024 6.49941 0.400024C8.12525 0.400024 9.67931 1.0728 10.8213 2.26191C11.9624 3.4502 12.5994 5.05686 12.5994 6.7273C12.5994 9.18674 11.0938 11.3984 9.69321 12.9379C8.98207 13.7195 8.27277 14.3554 7.74177 14.7957C7.47582 15.0162 7.25344 15.1886 7.09637 15.3068C7.01781 15.3658 6.9555 15.4114 6.91215 15.4427C6.89047 15.4583 6.87353 15.4704 6.86166 15.4788L6.84769 15.4886L6.84363 15.4914L6.84235 15.4923C6.84218 15.4924 6.84157 15.4929 6.49941 15ZM6.49941 15L6.84235 15.4923C6.6366 15.6352 6.36267 15.6355 6.15692 15.4926L6.49941 15ZM6.49941 5.41821C5.84093 5.41821 5.26608 5.98118 5.26608 6.7273C5.26608 7.47342 5.84093 8.03639 6.49941 8.03639C7.1579 8.03639 7.73275 7.47342 7.73275 6.7273C7.73275 5.98118 7.1579 5.41821 6.49941 5.41821ZM4.06608 6.7273C4.06608 5.36469 5.13285 4.21821 6.49941 4.21821C7.86597 4.21821 8.93275 5.36469 8.93275 6.7273C8.93275 8.0899 7.86597 9.23639 6.49941 9.23639C5.13285 9.23639 4.06608 8.0899 4.06608 6.7273Z"
												  fill="currentColor"/>
										</svg>
										<?php $listing->the_locations( true, true ); ?>
									</li>
								<?php endif; ?>
								<li>
									<svg width="16" height="12" viewBox="0 0 16 12" fill="none"
										 xmlns="http://www.w3.org/2000/svg">
										<path fill-rule="evenodd" clip-rule="evenodd"
											  d="M1.68652 6.00002C1.75679 6.11959 1.85087 6.27339 1.96807 6.45162C2.26198 6.89859 2.69741 7.49325 3.26297 8.08573C4.40426 9.28133 6.00763 10.4 7.99941 10.4C9.9912 10.4 11.5946 9.28133 12.7358 8.08573C13.3014 7.49325 13.7368 6.89859 14.0307 6.45162C14.1479 6.27339 14.242 6.11959 14.3123 6.00002C14.242 5.88045 14.1479 5.72666 14.0307 5.54843C13.7368 5.10146 13.3014 4.5068 12.7358 3.91431C11.5946 2.71868 9.9912 1.60002 7.99941 1.60002C6.00763 1.60002 4.40426 2.71868 3.26297 3.91431C2.69741 4.5068 2.26198 5.10146 1.96807 5.54843C1.85087 5.72666 1.75679 5.88045 1.68652 6.00002ZM14.9994 6.00002C15.5341 5.72781 15.534 5.72761 15.5339 5.72739L15.5329 5.72542L15.5307 5.7212L15.5235 5.70742C15.5175 5.6959 15.509 5.67975 15.4979 5.65928C15.4759 5.61834 15.4438 5.56009 15.402 5.48699C15.3183 5.34086 15.195 5.13494 15.0334 4.88912C14.7108 4.39859 14.2315 3.74325 13.6039 3.08574C12.3588 1.78137 10.4622 0.400024 7.99941 0.400024C5.53665 0.400024 3.64002 1.78137 2.39494 3.08574C1.76732 3.74325 1.28798 4.39859 0.96542 4.88912C0.803772 5.13494 0.680525 5.34086 0.596835 5.48699C0.554968 5.56009 0.522933 5.61834 0.500878 5.65928C0.489848 5.67975 0.481309 5.6959 0.475277 5.70742L0.468111 5.7212L0.465942 5.72542L0.465211 5.72684C0.465097 5.72706 0.464716 5.72781 0.999414 6.00002L0.464716 5.72781C0.377647 5.89884 0.377647 6.1012 0.464716 6.27223L0.999414 6.00002C0.464716 6.27223 0.464602 6.27201 0.464716 6.27223L0.465211 6.2732L0.465942 6.27463L0.468111 6.27885L0.475277 6.29263C0.481309 6.30415 0.489848 6.3203 0.500878 6.34077C0.522933 6.3817 0.554968 6.43996 0.596835 6.51306C0.680525 6.65919 0.803772 6.86511 0.96542 7.11093C1.28798 7.60146 1.76732 8.25683 2.39494 8.91433C3.64002 10.2186 5.53665 11.6 7.99941 11.6C10.4622 11.6 12.3588 10.2186 13.6039 8.91433C14.2315 8.25683 14.7108 7.60146 15.0334 7.11093C15.195 6.86511 15.3183 6.65919 15.402 6.51306C15.4438 6.43996 15.4759 6.3817 15.4979 6.34077C15.509 6.3203 15.5175 6.30415 15.5235 6.29263L15.5307 6.27885L15.5329 6.27463L15.5336 6.2732C15.5337 6.27298 15.5341 6.27223 14.9994 6.00002ZM14.9994 6.00002L15.5341 6.27223C15.6212 6.1012 15.621 5.89842 15.5339 5.72739L14.9994 6.00002ZM7.99941 4.72502C7.26618 4.72502 6.69032 5.30601 6.69032 6.00002C6.69032 6.69404 7.26618 7.27502 7.99941 7.27502C8.73264 7.27502 9.3085 6.69404 9.3085 6.00002C9.3085 5.30601 8.73264 4.72502 7.99941 4.72502ZM5.49032 6.00002C5.49032 4.62297 6.62392 3.52502 7.99941 3.52502C9.37491 3.52502 10.5085 4.62297 10.5085 6.00002C10.5085 7.37707 9.37491 8.47503 7.99941 8.47503C6.62392 8.47503 5.49032 7.37707 5.49032 6.00002Z"
											  fill="currentColor"/>
									</svg>
									<?php
									$views = $listing->get_view_counts();
									printf(
										esc_html(
										/* translators: views count */
											_n( '%1$s View', '%1$s Views', $views, 'classified-listing' )
										),
										esc_html( number_format_i18n( $views ) )
									);
									?>
								</li>
								<li>
									<svg width="17" height="24" viewBox="0 0 17 24" fill="none"
										 xmlns="http://www.w3.org/2000/svg">
										<path
											d="M10.7895 6.89375C10.7581 6.9499 10.7057 6.99128 10.6438 7.00878C10.5819 7.02628 10.5156 7.01848 10.4595 6.98708C10.4033 6.95569 10.3619 6.90328 10.3444 6.84138C10.3269 6.77948 10.3347 6.71316 10.3661 6.65701C10.8051 5.87839 11.0255 4.99555 11.0038 4.10195C10.9822 3.20835 10.7194 2.33722 10.2432 1.58075C10.2262 1.55385 10.2146 1.52385 10.2091 1.49247C10.2037 1.4611 10.2045 1.42895 10.2115 1.39788C10.2184 1.36681 10.2315 1.33742 10.2498 1.31138C10.2681 1.28534 10.2914 1.26317 10.3183 1.24613C10.3452 1.22909 10.3752 1.21752 10.4066 1.21207C10.438 1.20662 10.4701 1.20741 10.5012 1.21439C10.5323 1.22136 10.5617 1.23439 10.5877 1.25272C10.6137 1.27106 10.6359 1.29434 10.6529 1.32125C11.1785 2.15055 11.4688 3.10707 11.4929 4.08859C11.5169 5.0701 11.2738 6.0397 10.7895 6.89375Z"
											fill="#797979"/>
										<path
											d="M13.9311 21.5537C15.4198 18.9906 15.3561 18.1847 15.2013 16.1315C15.1218 15.1651 15.0747 14.1964 15.0601 13.2269L15.0237 10.7229C15.0213 10.5401 14.9467 10.3658 14.8162 10.2378C14.6857 10.1099 14.5099 10.0387 14.3271 10.04C14.2359 10.0394 14.1454 10.0568 14.0609 10.0913C13.9764 10.1258 13.8996 10.1767 13.8349 10.241C13.7701 10.3053 13.7188 10.3818 13.6837 10.4661C13.6486 10.5504 13.6306 10.6407 13.6306 10.732V11.2783C13.6306 11.4522 13.5615 11.6189 13.4386 11.7419C13.3156 11.8648 13.1489 11.9339 12.975 11.9339C12.8011 11.9339 12.6344 11.8648 12.5114 11.7419C12.3885 11.6189 12.3194 11.4522 12.3194 11.2783V9.57559C12.3207 9.43364 12.2794 9.29456 12.2009 9.17629C12.1224 9.05803 12.0102 8.96601 11.8789 8.91211C11.7476 8.85821 11.6031 8.8449 11.4641 8.8739C11.3252 8.90289 11.1981 8.97287 11.0993 9.07479C10.9659 9.20741 10.8906 9.38751 10.8899 9.57559V10.7957C10.8939 10.9216 10.8583 11.0456 10.788 11.1502C10.7178 11.2548 10.6164 11.3346 10.4983 11.3785C10.4217 11.4094 10.3397 11.4294 10.257 11.4285C10.176 11.4283 10.0957 11.4129 10.0203 11.383C9.90142 11.3389 9.79954 11.2584 9.72922 11.1529C9.65889 11.0474 9.62373 10.9224 9.62876 10.7957V8.86536C9.63144 8.7281 9.59269 8.59321 9.51756 8.4783C9.44243 8.36339 9.33441 8.2738 9.2076 8.2212C9.08078 8.16861 8.94105 8.15546 8.80665 8.18347C8.67225 8.21148 8.54941 8.27935 8.45416 8.37823C8.38936 8.44174 8.33787 8.51753 8.30269 8.60118C8.26752 8.68482 8.24936 8.77463 8.24929 8.86536V11.2874C8.24907 11.4678 8.18189 11.6418 8.06077 11.7755C7.93966 11.9092 7.77322 11.9932 7.5937 12.0113C7.40176 12.0304 7.2101 11.9725 7.06074 11.8505C6.91138 11.7284 6.81653 11.5521 6.79698 11.3602C6.79284 11.3361 6.7898 11.3118 6.78787 11.2874V4.24437C6.78873 4.11319 6.75047 3.98472 6.678 3.87537C6.60552 3.76602 6.5021 3.68074 6.38095 3.63042C6.25979 3.5801 6.12639 3.56703 5.99777 3.59286C5.86915 3.61869 5.75114 3.68225 5.6588 3.77545C5.59681 3.8368 5.54759 3.90983 5.51399 3.99032C5.48039 4.07081 5.46307 4.15715 5.46304 4.24437V15.1481C5.46304 15.6034 5.08516 15.6625 4.86663 15.6944H4.85297C4.73576 15.7166 4.61446 15.6951 4.51208 15.6338C4.4097 15.5726 4.33337 15.4759 4.29754 15.3621C4.11056 15.1084 3.93878 14.8439 3.78309 14.5699C3.28229 13.7368 2.58118 12.5667 2.39907 12.4165C2.26273 12.3002 2.08748 12.2397 1.90845 12.2472C1.72942 12.2548 1.55984 12.3297 1.43371 12.4569C1.30758 12.5842 1.23423 12.7545 1.22835 12.9336C1.22248 13.1127 1.28451 13.2873 1.40203 13.4226L1.96656 14.0737C2.01664 14.1328 2.04851 14.1966 2.07127 14.2603L2.57207 15.6625C3.58732 18.5125 3.64196 18.6764 6.55568 21.5128C6.69736 21.6504 6.80957 21.8154 6.88549 21.9978C6.9614 22.1801 6.99944 22.376 6.9973 22.5735V22.6236L6.98819 22.8194H13.7171L13.7307 22.2731V22.2275C13.7422 21.9901 13.811 21.7589 13.9311 21.5537ZM16.171 16.0586C16.3394 18.3259 16.4077 19.2182 14.7688 22.0363C14.7291 22.1044 14.7057 22.1808 14.7005 22.2594V22.2958L14.6777 23.088V23.1244C14.6749 23.3009 14.603 23.4693 14.4774 23.5934C14.3515 23.7184 14.1814 23.7888 14.0039 23.7891H6.68316C6.50803 23.7883 6.34 23.7198 6.21423 23.5979L6.20513 23.5888C6.08049 23.4626 6.01021 23.2927 6.00936 23.1153V23.0926L6.02757 22.5918C6.02723 22.5811 6.02723 22.5705 6.02757 22.5599V22.5508C6.0269 22.4193 5.97457 22.2934 5.88188 22.2002C2.80426 19.2091 2.74052 19.0315 1.65698 15.9812L1.17895 14.6382L0.669043 14.0554C0.461708 13.8188 0.325219 13.5285 0.275206 13.2178C0.225192 12.9071 0.263675 12.5887 0.386248 12.2989C0.508821 12.0091 0.71053 11.7596 0.968277 11.5791C1.22602 11.3986 1.52939 11.2944 1.84364 11.2783C2.27388 11.2517 2.69784 11.3919 3.02734 11.6698C3.3005 11.9066 3.96975 12.9947 4.49331 13.8642V4.24437C4.49083 3.91994 4.58524 3.60214 4.76444 3.33168C4.94364 3.06122 5.19949 2.85039 5.49922 2.72619C5.79896 2.602 6.12894 2.57008 6.44692 2.63454C6.7649 2.69899 7.0564 2.85688 7.28412 3.08799C7.43605 3.23974 7.55649 3.42003 7.63853 3.61848C7.72056 3.81693 7.76258 4.02964 7.76215 4.24437V7.69532C7.95887 7.49554 8.20318 7.3491 8.4721 7.26976C8.74102 7.19043 9.0257 7.18082 9.29936 7.24184C9.57301 7.30285 9.82665 7.43249 10.0364 7.61854C10.2461 7.8046 10.4051 8.04096 10.4983 8.30538C10.819 8.02238 11.2358 7.87274 11.6633 7.88713C12.0907 7.90152 12.4965 8.07885 12.7974 8.38278C13.0706 8.65594 13.2482 9.02016 13.2846 9.4299C13.5274 9.23285 13.8208 9.1083 14.1312 9.07056C14.4416 9.03283 14.7564 9.08344 15.0393 9.21658C15.3223 9.34973 15.5619 9.56 15.7307 9.82323C15.8994 10.0865 15.9905 10.392 15.9934 10.7047L16.0253 13.2132C16.0435 14.3832 16.1118 15.2983 16.171 16.0586Z"
											fill="#797979"/>
										<path
											d="M4.70256 7.61327C4.76294 7.63621 4.82995 7.63423 4.88886 7.60776C4.94777 7.58129 4.99376 7.5325 5.0167 7.47213C5.03964 7.41176 5.03766 7.34475 5.01119 7.28583C4.98473 7.22692 4.93594 7.18094 4.87557 7.15799C4.18319 6.88581 3.60687 6.38157 3.24514 5.73148C2.88341 5.08139 2.75874 4.32583 2.89245 3.594C3.02616 2.86216 3.40994 2.1995 3.97818 1.71931C4.54641 1.23913 5.2638 0.971255 6.00769 0.961485C6.75158 0.951716 7.47576 1.20066 8.05641 1.66575C8.63705 2.13085 9.03811 2.7832 9.19099 3.51128C9.34387 4.23935 9.23909 4.99792 8.89456 5.65729C8.55003 6.31665 7.98714 6.83586 7.30216 7.12613C7.24299 7.15088 7.19608 7.19812 7.17175 7.25746C7.14742 7.3168 7.14765 7.38337 7.1724 7.44254C7.19716 7.5017 7.2444 7.54861 7.30374 7.57295C7.36308 7.59728 7.42965 7.59704 7.48882 7.57229C8.27802 7.23756 8.92637 6.63895 9.32289 5.87891C9.71942 5.11887 9.83947 4.24464 9.66251 3.40584C9.48555 2.56705 9.02257 1.81582 8.35281 1.28074C7.68305 0.745649 6.84815 0.459963 5.99098 0.472568C5.13381 0.485173 4.30767 0.795287 3.65393 1.34984C3.0002 1.90439 2.55951 2.6689 2.40729 3.51254C2.25507 4.35618 2.40078 5.22649 2.81949 5.97455C3.23819 6.7226 3.90385 7.30188 4.70256 7.61327ZM10.7804 6.91215C10.749 6.9683 10.6966 7.00967 10.6347 7.02717C10.5728 7.04468 10.5065 7.03687 10.4503 7.00548C10.3942 6.97409 10.3528 6.92167 10.3353 6.85977C10.3178 6.79787 10.3256 6.73155 10.357 6.67541L10.7804 6.91215ZM10.6529 1.32143C10.6359 1.29453 10.6137 1.27124 10.5877 1.25291C10.5617 1.23457 10.5323 1.22155 10.5012 1.21457C10.4701 1.20759 10.438 1.20681 10.4066 1.21225C10.3752 1.2177 10.3452 1.22927 10.3183 1.24631C10.2914 1.26335 10.2681 1.28552 10.2498 1.31156C10.2315 1.3376 10.2184 1.36699 10.2115 1.39807C10.2045 1.42914 10.2037 1.46128 10.2091 1.49266C10.2146 1.52404 10.2262 1.55403 10.2432 1.58094C10.2776 1.63527 10.3322 1.67371 10.395 1.6878C10.4577 1.70189 10.5235 1.69047 10.5778 1.65606C10.6322 1.62164 10.6706 1.56706 10.6847 1.5043C10.6988 1.44155 10.6874 1.37577 10.6529 1.32143ZM1.43828 1.32599C1.40447 1.38032 1.39363 1.44586 1.40814 1.50819C1.42266 1.57052 1.46134 1.62452 1.51567 1.65833C1.57001 1.69214 1.63555 1.70298 1.69788 1.68847C1.7602 1.67395 1.81421 1.63527 1.84802 1.58094L1.86168 1.56273C1.89549 1.50839 1.90633 1.44285 1.89181 1.38052C1.8773 1.3182 1.83862 1.26419 1.78428 1.23038C1.72995 1.19657 1.66441 1.18573 1.60208 1.20025C1.53975 1.21476 1.48574 1.25344 1.45194 1.30777L1.43828 1.32599Z"
											fill="#797979"/>
										<path
											d="M1.30167 6.89375C1.33306 6.9499 1.38547 6.99128 1.44737 7.00878C1.50927 7.02628 1.57559 7.01848 1.63174 6.98708C1.68788 6.95569 1.72926 6.90328 1.74676 6.84138C1.76426 6.77948 1.75646 6.71316 1.72507 6.65701C1.28605 5.87839 1.0657 4.99556 1.08734 4.10195C1.10898 3.20835 1.3718 2.33722 1.84799 1.58075C1.8824 1.52642 1.89382 1.46064 1.87973 1.39788C1.86565 1.33513 1.82721 1.28054 1.77287 1.24613C1.71854 1.21172 1.65276 1.2003 1.59 1.21439C1.52725 1.22847 1.47266 1.26691 1.43825 1.32125C0.912688 2.15055 0.622363 3.10707 0.598307 4.08859C0.57425 5.0701 0.817365 6.0397 1.30167 6.89375Z"
											fill="#797979"/>
										<path
											d="M1.31095 6.91233L1.30184 6.89412C1.27045 6.83797 1.26264 6.77165 1.28015 6.70975C1.29765 6.64785 1.33903 6.59544 1.39517 6.56405C1.45132 6.53266 1.51764 6.52485 1.57954 6.54235C1.64144 6.55986 1.69385 6.60123 1.72524 6.65738L1.73435 6.67559L1.31095 6.91233Z"
											fill="#797979"/>
									</svg>
									<?php
									$reveals = $listing->get_phone_whatsapp_reveal_counts();
									printf(
										esc_html(
										/* translators:  reveal count */
											_n( '%1$s Reveal', '%1$s Reveals', $reveals, 'classified-listing' )
										),
										esc_html( number_format_i18n( $reveals ) )
									);
									?>
								</li>
								<li>
									<svg width="17" height="17" viewBox="0 0 17 17" fill="none"
										 xmlns="http://www.w3.org/2000/svg">
										<path
											d="M4.20961 10.676C5.79371 12.5696 7.70062 14.0606 9.8771 15.1155C10.7058 15.5082 11.814 15.9741 13.0486 16.054C13.1252 16.0573 13.1984 16.0607 13.2749 16.0607C14.1036 16.0607 14.7692 15.7744 15.3116 15.1854C15.315 15.1821 15.3216 15.1754 15.3249 15.1688C15.518 14.9358 15.7376 14.7261 15.9672 14.5032C16.1236 14.3534 16.2834 14.197 16.4365 14.0373C17.1453 13.2985 17.1453 12.36 16.4298 11.6445L14.4297 9.64438C14.0903 9.29162 13.6843 9.10525 13.2583 9.10525C12.8323 9.10525 12.423 9.29162 12.0735 9.64105L10.8821 10.8325C10.7723 10.7692 10.6592 10.7126 10.5527 10.6594C10.4196 10.5928 10.2964 10.5296 10.1866 10.4597C9.10169 9.77084 8.11662 8.87229 7.17481 7.7175C6.69891 7.11514 6.37943 6.60929 6.15646 6.09346C6.46929 5.81059 6.76215 5.5144 7.04502 5.22487C7.14486 5.1217 7.24802 5.01854 7.35119 4.91537C7.71061 4.55595 7.90363 4.13996 7.90363 3.71731C7.90363 3.29466 7.71394 2.87867 7.35119 2.51925L6.35946 1.52753C6.24299 1.41105 6.13316 1.2979 6.02001 1.18142C5.80037 0.95512 5.57074 0.722164 5.34444 0.512503C5.00166 0.176381 4.59898 0 4.17301 0C3.75036 0 3.34435 0.176381 2.98826 0.515831L1.74361 1.76048C1.29101 2.21308 1.03476 2.76219 0.981508 3.39783C0.918278 4.19321 1.06471 5.03851 1.44409 6.06018C2.02648 7.64096 2.90506 9.10858 4.20961 10.676ZM1.79353 3.46772C1.83346 3.0251 2.00319 2.6557 2.32267 2.33622L3.56066 1.09822C3.75368 0.911856 3.96667 0.815346 4.17301 0.815346C4.37601 0.815346 4.58234 0.911856 4.77204 1.10488C4.99501 1.31121 5.20467 1.52753 5.43097 1.75715C5.54412 1.87363 5.6606 1.99011 5.77707 2.10992L6.7688 3.10164C6.97513 3.30797 7.08163 3.51764 7.08163 3.72397C7.08163 3.9303 6.97513 4.13996 6.7688 4.34629C6.66563 4.44946 6.56247 4.55595 6.4593 4.65912C6.1498 4.97195 5.86027 5.26813 5.54079 5.55101L5.52415 5.56765C5.24793 5.84387 5.29119 6.10677 5.35775 6.30645C5.36108 6.31644 5.36441 6.32309 5.36774 6.33307C5.62399 6.94874 5.98008 7.53446 6.53584 8.23333C7.53423 9.46467 8.58586 10.4198 9.74398 11.1553C9.88708 11.2484 10.0402 11.3217 10.1833 11.3949C10.3164 11.4614 10.4395 11.5247 10.5493 11.5946C10.5627 11.6012 10.5726 11.6079 10.586 11.6145C10.6958 11.6711 10.8023 11.6977 10.9088 11.6977C11.175 11.6977 11.348 11.528 11.4046 11.4714L12.6493 10.2268C12.8423 10.0337 13.052 9.93058 13.2583 9.93058C13.5112 9.93058 13.7175 10.087 13.8473 10.2268L15.8541 12.2302C16.2534 12.6295 16.2501 13.0622 15.8441 13.4848C15.7043 13.6346 15.5579 13.7777 15.4015 13.9274C15.1685 14.1537 14.9256 14.3867 14.7059 14.6496C14.3232 15.0623 13.8673 15.2553 13.2783 15.2553C13.2217 15.2553 13.1618 15.252 13.1052 15.2486C12.0136 15.1787 10.9986 14.7528 10.2365 14.39C8.16654 13.3883 6.34948 11.9673 4.84192 10.1635C3.6006 8.66929 2.76529 7.27821 2.21285 5.78729C1.87007 4.87211 1.74028 4.13663 1.79353 3.46772Z"
											fill="#797979"/>
									</svg>
									<?php
									$phone_clicks = $listing->get_phone_click_counts();
									printf(
										esc_html(
										/* translators:  click count */
											_n( '%1$s Click', '%1$s Clicks', $phone_clicks, 'classified-listing' )
										),
										esc_html( number_format_i18n( $phone_clicks ) )
									); ?>
								</li>
								<li>
									<svg width="16" height="16" viewBox="0 0 16 16" fill="none"
										 xmlns="http://www.w3.org/2000/svg">
										<g clip-path="url(#clip0_3475_1884)">
											<path
												d="M8 0C3.58862 0 0 3.58862 0 8C0 9.50492 0.418154 10.9658 1.21138 12.2345C0.895385 13.3415 0.324615 15.4357 0.318462 15.4575C0.303898 15.5107 0.303928 15.5668 0.318548 15.6199C0.333168 15.673 0.361837 15.7212 0.401538 15.7594C0.482462 15.8372 0.599385 15.8649 0.705846 15.8323L3.87692 14.8569C5.12162 15.6061 6.54722 16.0014 8 16C12.4114 16 16 12.4114 16 8C16 3.58862 12.4114 0 8 0ZM8 15.3846C6.6146 15.386 5.25689 14.9966 4.08277 14.2612C4.04532 14.2378 4.00327 14.2227 3.95947 14.217C3.91566 14.2112 3.87114 14.215 3.82892 14.228L1.06 15.0803C1.31583 14.1427 1.57614 13.2062 1.84092 12.2711C1.86554 12.1855 1.85169 12.0932 1.80338 12.0185C1.02617 10.8225 0.613417 9.42634 0.615385 8C0.615385 3.92831 3.92831 0.615385 8 0.615385C12.0717 0.615385 15.3846 3.92831 15.3846 8C15.3846 12.0717 12.0717 15.3846 8 15.3846Z"
												fill="#797979"/>
											<path
												d="M11.8646 9.88864C11.3782 9.61858 10.964 9.34774 10.6618 9.15013C10.431 8.99943 10.2643 8.89062 10.142 8.82923C9.8003 8.65876 9.54131 8.77917 9.44277 8.87876C9.4305 8.891 9.41947 8.90441 9.40984 8.91881C9.05494 9.45128 8.5915 9.96056 8.45581 9.98797C8.29905 9.96346 7.56529 9.54639 6.83601 8.9391C6.09144 8.31863 5.623 7.7245 5.55423 7.31981C6.0319 6.82818 6.20394 6.51887 6.20394 6.16687C6.20394 5.80408 5.35768 4.28939 5.20461 4.13632C5.051 3.98298 4.70507 3.959 4.17629 4.06439C4.12535 4.07471 4.07854 4.09971 4.04165 4.13632C3.97763 4.20034 2.47955 5.72767 3.19144 7.5788C3.97289 9.61041 5.97868 11.9719 8.53591 12.3555C8.82652 12.399 9.09894 12.4206 9.35398 12.4206C10.8584 12.4206 11.7463 11.6636 11.9963 10.1621C12.0054 10.1085 11.9976 10.0534 11.974 10.0044C11.9504 9.95541 11.9122 9.91495 11.8646 9.88864ZM8.61416 11.8344C5.90991 11.4289 4.20659 8.74966 3.68334 7.38963C3.1643 6.04067 4.12149 4.83794 4.36177 4.56604C4.55726 4.53284 4.76303 4.51888 4.84892 4.53231C5.02835 4.78182 5.64961 5.95557 5.67701 6.16687C5.67701 6.3052 5.63195 6.49779 5.09553 7.03448C5.07102 7.0589 5.05158 7.08794 5.03833 7.1199C5.02508 7.15187 5.01828 7.18615 5.01833 7.22075C5.01833 8.60027 7.92809 10.5141 8.44343 10.5141C8.89159 10.5141 9.47597 9.76086 9.80873 9.27001C9.84307 9.27335 9.87635 9.28375 9.90648 9.30058C10.0013 9.34826 10.1657 9.4555 10.3736 9.59145C10.6481 9.77087 11.0128 10.009 11.4433 10.2559C11.2478 11.1965 10.7014 12.1479 8.61416 11.8344Z"
												fill="#797979"/>
										</g>
										<defs>
											<clipPath id="clip0_3475_1884">
												<rect width="16" height="16" fill="white"/>
											</clipPath>
										</defs>
									</svg>
									<?php
									$wa_clicks = $listing->get_whatsapp_click_counts();
									printf(
										esc_html(
										/* translators: click count */
											_n( '%1$s Click', '%1$s Clicks', $wa_clicks, 'classified-listing' )
										),
										esc_html( number_format_i18n( $wa_clicks ) )
									); ?>
								</li>
								<?php do_action( 'rtcl_my_listings_meta_lists', $listing ); ?>
							</ul>
							<div
								class="listing-status-mobile <?php echo esc_attr( strtolower( $post->post_status ) ); ?>">
								<span><?php esc_html_e( 'Status:', 'classified-listing' ); ?></span>
								<span><?php echo esc_html( Functions::get_status_i18n( $post->post_status ) ); ?></span>
							</div>
						</div>
						<span class="rtcl-my-listings-table-toggle-info">
								<span class="rtcl-icon rtcl-icon-angle-down"></span>
							</span>
						<?php do_action( 'rtcl_listing_loop_extra_meta', $listing ); ?>
					</td>
					<td class="price-cell list-on-responsive"
						data-column="<?php esc_html_e( 'Price:', 'classified-listing' ); ?>">
						<?php if ( $listing->can_show_price() ) {
							// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
							Functions::print_html( $listing->get_price_html() );
						} ?>
					</td>
					<td class="list-on-responsive"
						data-column="<?php esc_html_e( 'Expires On:', 'classified-listing' ); ?>">
						<?php
						if ( $listing->get_status() !== 'pending' ) {
							if ( get_post_meta( $listing->get_id(), 'never_expires', true ) ) {
								esc_html_e( 'Never Expires', 'classified-listing' );
							} else if ( $expiry_date = get_post_meta( $listing->get_id(), 'expiry_date', true ) ) {
								// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
								echo date_i18n( get_option( 'date_format' ) . ' ' . get_option( 'time_format' ), strtotime( $expiry_date ) );
							}
						}
						?>
					</td>
					<td class="status-cell list-on-responsive"
						data-column="<?php esc_html_e( 'Status:', 'classified-listing' ); ?>">
							<span class="<?php echo esc_attr( strtolower( $post->post_status ) ); ?>">
								<?php echo esc_html( Functions::get_status_i18n( $post->post_status ) ); ?>
							</span>
					</td>
					<td class="list-on-responsive"
						data-column="<?php esc_html_e( 'Action:', 'classified-listing' ); ?>">
						<?php if ( apply_filters( 'rtcl_my_listing_actions_button_display', true ) ) { ?>
							<div class="rtcl-actions-wrap">
									<span class="actions-dot">
										<svg width="18" height="4" viewBox="0 0 18 4" fill="none"
											 xmlns="http://www.w3.org/2000/svg">
											<circle cx="2" cy="2" r="2" fill="#646464"/>
											<circle cx="9" cy="2" r="2" fill="#646464"/>
											<circle cx="16" cy="2" r="2" fill="#646464"/>
										</svg>
									</span>
								<div class="rtcl-actions">
									<?php do_action( 'rtcl_my_listing_actions', $listing ); ?>
								</div>
							</div>
						<?php } ?>
					</td>
				</tr>
			<?php endwhile; ?>
			<?php wp_reset_postdata(); ?>
			</tbody>
		</table>
	</div>
	<!-- pagination here -->
	<?php Pagination::pagination( $rtcl_query, true ); ?>
<?php else: ?>
	<p class="rtcl-no-data-found"><?php esc_html_e( "No listing found.", 'classified-listing' ); ?></p>
<?php endif; ?>