<?php

namespace RtclPro\Gateways\Authorize\lib\Types;

class CustomerAddressType extends NameAndAddressType {

	/**
	 * @property string $phoneNumber
	 */
	private $phoneNumber = null;

	/**
	 * @property string $faxNumber
	 */
	private $faxNumber = null;

	/**
	 * @property string $email
	 */
	private $email = null;

	/**
	 * Gets as phoneNumber
	 *
	 * @return string
	 */
	public function getPhoneNumber() {
		return $this->phoneNumber;
	}

	/**
	 * Sets a new phoneNumber
	 *
	 * @param string $phoneNumber
	 *
	 * @return self
	 */
	public function setPhoneNumber( $phoneNumber ) {
		$this->phoneNumber = $phoneNumber;

		return $this;
	}

	/**
	 * Gets as faxNumber
	 *
	 * @return string
	 */
	public function getFaxNumber() {
		return $this->faxNumber;
	}

	/**
	 * Sets a new faxNumber
	 *
	 * @param string $faxNumber
	 *
	 * @return self
	 */
	public function setFaxNumber( $faxNumber ) {
		$this->faxNumber = $faxNumber;

		return $this;
	}

	/**
	 * Gets as email
	 *
	 * @return string
	 */
	public function getEmail() {
		return $this->email;
	}

	/**
	 * Sets a new email
	 *
	 * @param string $email
	 *
	 * @return self
	 */
	public function setEmail( $email ) {
		$this->email = $email;

		return $this;
	}


}